/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.PatrollerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.item.RaidHornItem;

@Module(mod="charm", hasSubscriptions=true, description="Raid horns are sometimes dropped from raid leaders and can be used to call off or start raids.")
public class RaidHorns
extends CharmModule {
    public static RaidHornItem RAID_HORN;
    public static double lootingBoost;
    @Config(name="Drop chance", description="Chance (out of 1.0) of a patrol captain dropping a raid horn when killed by the player.")
    public static double dropChance;
    @Config(name="Volume", description="Volume of the raid horn sound effect when used.  1.0 is maximum volume.")
    public static double volume;

    @Override
    public void register() {
        RAID_HORN = new RaidHornItem(this);
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        if (!event.isCanceled()) {
            this.tryDrop(event.getEntityLiving(), event.getSource(), event.getLootingLevel());
        }
    }

    public void tryDrop(LivingEntity entity, DamageSource source, int lootingLevel) {
        if (!entity.field_70170_p.field_72995_K && entity instanceof PatrollerEntity && source.func_76346_g() instanceof PlayerEntity && (double)entity.field_70170_p.field_73012_v.nextFloat() <= dropChance + lootingBoost * (double)lootingLevel && ((PatrollerEntity)entity).func_213630_eb()) {
            BlockPos pos = entity.func_233580_cy_();
            ItemStack potion = new ItemStack((IItemProvider)RAID_HORN);
            entity.field_70170_p.func_217376_c((Entity)new ItemEntity(entity.func_130014_f_(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), potion));
        }
    }

    static {
        lootingBoost = 0.25;
        dropChance = 0.05;
        volume = 0.75;
    }
}

